        import { initializeApp } from 'https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js';
        import { getDatabase, ref, push, set, onValue, query, orderByChild } from 'https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js';
        import { getAuth, signInAnonymously } from 'https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js';

        // Wait for configuration to load
        function waitForConfig() {
            return new Promise((resolve) => {
                const checkConfig = () => {
                    if (window.FIREBASE_CONFIG && window.CONFIG_LOADED) {
                        resolve(window.FIREBASE_CONFIG);
                    } else {
                        setTimeout(checkConfig, 100);
                    }
                };
                checkConfig();
            });
        }

        // Initialize Firebase with loaded configuration
        async function initializeFirebaseApp() {
            try {
                const firebaseConfig = await waitForConfig();
                window.FIREBASE_CONFIG_LOADED = true;

                // Initialize Firebase
                const app = initializeApp(firebaseConfig);
                const database = getDatabase(app);
                const auth = getAuth(app);

                // Make Firebase available globally
                window.firebaseApp = app;
                window.firebaseDatabase = database;
                window.firebaseAuth = auth;
                window.firebaseRef = ref;
                window.firebasePush = push;
                window.firebaseSet = set;
                window.firebaseOnValue = onValue;
                window.firebaseQuery = query;
                window.firebaseOrderByChild = orderByChild;
                window.firebaseSignInAnonymously = signInAnonymously;

                console.log('Firebase initialized successfully');
            } catch (error) {
                console.error('Failed to initialize Firebase:', error);
            }
        }

        // Start initialization
        initializeFirebaseApp();