        import { initializeApp } from 'https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js';
        import { getDatabase, ref, onValue, query, orderByChild, push, set, remove } from 'https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js';
        import { getAuth, signInWithEmailAndPassword, signOut, onAuthStateChanged, EmailAuthProvider, updateEmail, updatePassword, reauthenticateWithCredential } from 'https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js';
        import { getFirestore, doc, setDoc, getDoc, collection } from 'https://www.gstatic.com/firebasejs/10.7.1/firebase-firestore.js';

        // Wait for configuration to load
        function waitForConfig() {
            return new Promise((resolve) => {
                const checkConfig = () => {
                    if (window.FIREBASE_CONFIG && window.CONFIG_LOADED) {
                        resolve(window.FIREBASE_CONFIG);
                    } else {
                        setTimeout(checkConfig, 100);
                    }
                };
                checkConfig();
            });
        }

        // Initialize Firebase with loaded configuration
        async function initializeFirebaseApp() {
            try {
                const firebaseConfig = await waitForConfig();
                window.FIREBASE_CONFIG_LOADED = true;

                // Initialize Firebase
                const app = initializeApp(firebaseConfig);
                const database = getDatabase(app);
                const auth = getAuth(app);
                const firestore = getFirestore(app);

                // Make Firebase available globally
                window.firebaseApp = app;
                window.firebaseDatabase = database;
                window.firebaseAuth = auth;
                window.firebaseFirestore = firestore;
                window.firebaseRef = ref;
                window.firebaseOnValue = onValue;
                window.firebaseQuery = query;
                window.firebaseOrderByChild = orderByChild;
                window.firebasePush = push;
                window.firebaseSet = set;
                window.firebaseRemove = remove;
                window.firebaseSignInWithEmailAndPassword = signInWithEmailAndPassword;
                window.firebaseSignOut = signOut;
                window.firebaseOnAuthStateChanged = onAuthStateChanged;
                window.firebaseDoc = doc;
                window.firebaseSetDoc = setDoc;
                window.firebaseGetDoc = getDoc;
                window.firebaseCollection = collection;
                window.firebaseEmailAuthProvider = EmailAuthProvider;
                window.firebaseUpdateEmail = updateEmail;
                window.firebaseUpdatePassword = updatePassword;
                window.firebaseReauthenticateWithCredential = reauthenticateWithCredential;

              console.log('Firebase initialized successfully');
              console.log('Firebase Auth:', auth);
                console.log('Firebase Database:', database);
            } catch (error) {
                console.error('Failed to initialize Firebase:', error);
                // Set error flags
                window.FIREBASE_INIT_ERROR = error;
            }
        }

        // Start initialization
        initializeFirebaseApp();